/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;

public class RelicViewScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("RelicViewScreen");
    public static final String[] TEXT = RelicViewScreen.uiStrings.TEXT;
    private static final float SPACE = 80.0f * Settings.scale;
    private static final float START_X = 600.0f * Settings.scale;
    private static final float START_Y = (float)Settings.HEIGHT - 300.0f * Settings.scale;
    private float scrollY;
    private float targetY;
    private float scrollLowerBound;
    private float scrollUpperBound;
    private int row;
    private int col;
    public MenuCancelButton button;
    private static final Color RED_OUTLINE_COLOR = new Color(-10132568);
    private static final Color GREEN_OUTLINE_COLOR = new Color(2147418280);
    private static final Color BLUE_OUTLINE_COLOR = new Color(-2016482392);
    private static final Color BLACK_OUTLINE_COLOR = new Color(168);
    private AbstractRelic hoveredRelic;
    private AbstractRelic clickStartedRelic;
    private ArrayList<AbstractRelic> relicGroup;
    private boolean grabbedScreen;
    private float grabStartY;

    public RelicViewScreen() {
        this.targetY = this.scrollY = START_Y;
        this.scrollLowerBound = 1000.0f * Settings.scale;
        this.scrollUpperBound = 2400.0f * Settings.scale;
        this.row = 0;
        this.col = 0;
        this.button = new MenuCancelButton();
        this.hoveredRelic = null;
        this.clickStartedRelic = null;
        this.relicGroup = null;
        this.grabbedScreen = false;
        this.grabStartY = 0.0f;
    }

    public void open() {
        if (Settings.isInfo) {
            RelicLibrary.unlockAndSeeAllRelics();
        }
        this.sortOnOpen();
        this.button.show(TEXT[0]);
        this.targetY = (float)Settings.HEIGHT - 100.0f * Settings.scale;
        this.scrollY = (float)Settings.HEIGHT - 400.0f * Settings.scale;
        CardCrawlGame.mainMenuScreen.darken();
    }

    private void sortOnOpen() {
        RelicLibrary.starterList = RelicLibrary.sortByStatus(RelicLibrary.starterList, false);
        RelicLibrary.commonList = RelicLibrary.sortByStatus(RelicLibrary.commonList, false);
        RelicLibrary.uncommonList = RelicLibrary.sortByStatus(RelicLibrary.uncommonList, false);
        RelicLibrary.rareList = RelicLibrary.sortByStatus(RelicLibrary.rareList, false);
        RelicLibrary.bossList = RelicLibrary.sortByStatus(RelicLibrary.bossList, false);
        RelicLibrary.specialList = RelicLibrary.sortByStatus(RelicLibrary.specialList, false);
        RelicLibrary.shopList = RelicLibrary.sortByStatus(RelicLibrary.shopList, false);
    }

    public void update() {
        if (this.hoveredRelic != null) {
            CardCrawlGame.cursor.changeType(GameCursor.CursorType.INSPECT);
            if (InputHelper.justClickedLeft) {
                this.clickStartedRelic = this.hoveredRelic;
            }
            if (InputHelper.justReleasedClickLeft && this.hoveredRelic == this.clickStartedRelic) {
                CardCrawlGame.relicPopup.open(this.hoveredRelic, this.relicGroup);
                this.clickStartedRelic = null;
            }
        } else {
            this.clickStartedRelic = null;
        }
        this.button.update();
        if (this.button.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            this.button.hide();
            CardCrawlGame.mainMenuScreen.lighten();
        }
        this.updateScrolling();
        InputHelper.justClickedLeft = false;
        this.hoveredRelic = null;
        this.relicGroup = null;
        this.updateList(RelicLibrary.starterList);
        this.updateList(RelicLibrary.commonList);
        this.updateList(RelicLibrary.uncommonList);
        this.updateList(RelicLibrary.rareList);
        this.updateList(RelicLibrary.bossList);
        this.updateList(RelicLibrary.specialList);
        this.updateList(RelicLibrary.shopList);
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.targetY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.targetY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.targetY;
            }
        } else if (InputHelper.isMouseDown) {
            this.targetY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
        this.scrollY = MathHelper.scrollSnapLerpSpeed(this.scrollY, this.targetY);
        this.resetScrolling();
    }

    private void resetScrolling() {
        if (this.targetY < this.scrollLowerBound) {
            this.targetY = MathHelper.scrollSnapLerpSpeed(this.targetY, this.scrollLowerBound);
        } else if (this.targetY > this.scrollUpperBound) {
            this.targetY = MathHelper.scrollSnapLerpSpeed(this.targetY, this.scrollUpperBound);
        }
    }

    private void updateList(ArrayList<AbstractRelic> list) {
        for (AbstractRelic r : list) {
            r.hitbox.move(r.currentX, r.currentY);
            r.update();
            if (!r.hitbox.hovered) continue;
            this.hoveredRelic = r;
            this.relicGroup = list;
        }
    }

    public void render(SpriteBatch sb) {
        this.row = -1;
        this.col = 0;
        this.renderList(sb, TEXT[1], TEXT[2], RelicLibrary.starterList);
        this.renderList(sb, TEXT[3], TEXT[4], RelicLibrary.commonList);
        this.renderList(sb, TEXT[5], TEXT[6], RelicLibrary.uncommonList);
        this.renderList(sb, TEXT[7], TEXT[8], RelicLibrary.rareList);
        this.renderList(sb, TEXT[9], TEXT[10], RelicLibrary.bossList);
        this.renderList(sb, TEXT[11], TEXT[12], RelicLibrary.specialList);
        this.renderList(sb, TEXT[13], TEXT[14], RelicLibrary.shopList);
        this.button.render(sb);
    }

    private void renderList(SpriteBatch sb, String msg, String desc, ArrayList<AbstractRelic> list) {
        this.row += 2;
        FontHelper.renderSmartText(sb, FontHelper.buttonLabelFont, msg, START_X - 50.0f * Settings.scale, this.scrollY + 4.0f * Settings.scale - SPACE * (float)this.row, 99999.0f, 0.0f, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, desc, START_X - 50.0f * Settings.scale + FontHelper.getSmartWidth(FontHelper.buttonLabelFont, msg, 99999.0f, 0.0f), this.scrollY - 0.0f * Settings.scale - SPACE * (float)this.row, 99999.0f, 0.0f, Settings.CREAM_COLOR);
        ++this.row;
        this.col = 0;
        for (AbstractRelic r : list) {
            if (this.col == 10) {
                this.col = 0;
                ++this.row;
            }
            r.currentX = START_X + SPACE * (float)this.col;
            r.currentY = this.scrollY - SPACE * (float)this.row;
            if (RelicLibrary.redList.contains(r)) {
                if (UnlockTracker.isRelicLocked(r.relicId)) {
                    r.renderLock(sb, RED_OUTLINE_COLOR);
                } else {
                    r.render(sb, false, RED_OUTLINE_COLOR);
                }
            } else if (RelicLibrary.greenList.contains(r)) {
                if (UnlockTracker.isRelicLocked(r.relicId)) {
                    r.renderLock(sb, GREEN_OUTLINE_COLOR);
                } else {
                    r.render(sb, false, GREEN_OUTLINE_COLOR);
                }
            } else if (RelicLibrary.blueList.contains(r)) {
                if (UnlockTracker.isRelicLocked(r.relicId)) {
                    r.renderLock(sb, BLUE_OUTLINE_COLOR);
                } else {
                    r.render(sb, false, BLUE_OUTLINE_COLOR);
                }
            } else if (UnlockTracker.isRelicLocked(r.relicId)) {
                r.renderLock(sb, BLACK_OUTLINE_COLOR);
            } else {
                r.render(sb, false, BLACK_OUTLINE_COLOR);
            }
            ++this.col;
        }
    }
}

